'use client' // Error boundaries must be Client Components

import { Text } from '@/components/typeography/text'
import { ClientErrorProps } from '@/types/utils'
import { useEffect } from 'react'

export default function Error({
  error,
  reset,
}: ClientErrorProps) {
  useEffect(() => {
    console.error(error)
  }, [error])

  return (
    <div className="flex flex-col justify-center items-center gap-3 w-full h-2/3">
      <Text variant={"h2"} className='text-center'>It looks like some services for this page may be down. Please come back at a later day.</Text>
      <Text variant={"p"} affects={"lead"} tint={"default"} className='text-center'>{error.message}</Text>
      <button
        onClick={
          () => reset()
        }
      >
        Retry current page.
      </button>
    </div>
  )
}

